/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.AsynchEventManager;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.ComputerSystemProvUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.BuildCommandPacket;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.ParseResponse;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.common.util.VersionComparator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.Policy;
import javax.security.auth.Subject;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbemcfg.GlobalConfig;

public class HscProviderUtils {
    static final int BUSY_RETRYS = 7;
    static final int TIMEOUT_RETRYS = 3;
    public static boolean HSC_ACCESS_CONTROL = false;
    private static int mSocketTimeoutValue = 30000;
    private static int mCmdBusyTimeoutValue = 120000;
    private static final String CONFIG_PROP_FILENAME = "/opt/hsc/data/hmcconfig.def";
    private static final String APP_TIMEOUT_PROP_NAME = "HMC_APP_TIMEOUT";
    public static final String SURVILLANCE_TIME = "HDWR_SURVILLANCE_TIME";
    public static final String CMD_BUSY_TIMEOUT = "CMD_BUSY_TIMEOUT";
    private static Properties mProps = null;

    public static void setAppTimeoutValue(int n) {
        mSocketTimeoutValue = n;
    }

    public static int getAppTimeoutValue() {
        return mSocketTimeoutValue;
    }

    public static String getConfigProperty(String string) {
        if (mProps == null) {
            return null;
        }
        return (String)mProps.get(string);
    }

    public static Hashtable doCSPCommand(String string, String[] stringArray, HscProviderSocket hscProviderSocket) throws CIMException {
        return HscProviderUtils.doCSPCommand(string, stringArray, hscProviderSocket, mCmdBusyTimeoutValue, mSocketTimeoutValue);
    }

    public static Hashtable doCSPCommand(String string, String[] stringArray, HscProviderSocket hscProviderSocket, String string2) throws CIMException {
        return HscProviderUtils.doCSPCommand(string, stringArray, hscProviderSocket, string2, mCmdBusyTimeoutValue, mSocketTimeoutValue);
    }

    public static Hashtable doCSPCommand(String string, String[] stringArray, HscProviderSocket hscProviderSocket, long l) throws CIMException {
        return HscProviderUtils.doCSPCommand(string, stringArray, hscProviderSocket, l, mSocketTimeoutValue);
    }

    public static Hashtable doCSPCommand(String string, String[] stringArray, HscProviderSocket hscProviderSocket, String string2, long l) throws CIMException {
        return HscProviderUtils.doCSPCommand(string, stringArray, hscProviderSocket, string2, l, mSocketTimeoutValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Hashtable doCSPCommand(String string, String[] stringArray, HscProviderSocket hscProviderSocket, String string2, long l, int n) throws CIMException {
        Object object;
        byte[] byArray = null;
        byte[] byArray2 = null;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ParseResponse parseResponse = null;
        Hashtable hashtable = null;
        boolean bl2 = false;
        try {
            System.out.println(" the command is ." + string);
            byArray2 = BuildCommandPacket.buildCommand(string, stringArray);
        }
        catch (Exception exception) {
            System.out.println(" Failed to build the command." + string);
            exception.printStackTrace();
            HSCLogUtils.serverLog(exception, HSCLogUtils._CECClassLogInfo);
            throw new HSCCIMException(exception);
        }
        while (n2 < 7 && n3 < 3) {
            byArray = hscProviderSocket.doCspCmd(byArray2, n);
            if (byArray == null) {
                n2 = 7;
                continue;
            }
            try {
                parseResponse = string2 == null ? new ParseResponse(byArray) : new ParseResponse(byArray, string2);
                if (!parseResponse.isNoErrorStatusResponse()) {
                    object = parseResponse.getAckData();
                    Integer n5 = (Integer)((Hashtable)object).get("ERROR_TYPE");
                    int n6 = n5;
                    if (n6 == 105) {
                        System.out.println(" inside NO_ECP");
                        throw new HSCCIMException("0200");
                    }
                    if (n6 == 7) {
                        block37: {
                            Object var21_26;
                            try {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    System.out.println(" the sleep of the doCsp interrupted..");
                                    var21_26 = null;
                                    break block37;
                                }
                                var21_26 = null;
                            }
                            catch (Throwable throwable) {
                                var21_26 = null;
                                throw throwable;
                            }
                        }
                        ++n3;
                        continue;
                    }
                    if (n6 == 255) {
                        block38: {
                            Object var23_27;
                            try {
                                try {
                                    Thread.sleep(l);
                                }
                                catch (InterruptedException interruptedException) {
                                    System.out.println(" the sleep of the doCsp interrupted..");
                                    var23_27 = null;
                                    break block38;
                                }
                                var23_27 = null;
                            }
                            catch (Throwable throwable) {
                                var23_27 = null;
                                throw throwable;
                            }
                        }
                        ++n2;
                        continue;
                    }
                    if (string.equals("OPEN_VIRTUAL_TTY") || string.equals("CLOSE_VIRTUAL_TTY")) {
                        System.out.println(" the ackHash is data is ..." + object);
                        return object;
                    }
                    if (n6 == 3) {
                        throw new HSCCIMException("020D");
                    }
                    if (n6 == 10) {
                        throw new HSCCIMException("020E");
                    }
                    if (n6 == 11) {
                        throw new HSCCIMException("020F");
                    }
                    if (n6 == 12) {
                        throw new HSCCIMException("0211");
                    }
                    if (n6 == 13) {
                        throw new HSCCIMException("0210");
                    }
                    if (n6 == 6) {
                        throw new HSCCIMException("0218");
                    }
                    String string3 = "Error Response from CSP :" + n6;
                    System.out.println(" Error ........." + string3);
                    String[] stringArray2 = new String[]{n5.toString()};
                    System.out.println(" the string val is ,," + stringArray2[0]);
                    throw new HSCCIMException("0203", stringArray2);
                }
                if (string.equals("OPEN_VIRTUAL_TTY")) return parseResponse.getVirtualTTYData();
                if (string.equals("CLOSE_VIRTUAL_TTY")) {
                    return parseResponse.getVirtualTTYData();
                }
                object = string;
                if (string.startsWith("SET_NOTIFICATION_EVENT")) {
                    object = "SET_NOTIFICATION_EVENT";
                }
                if (!parseResponse.isValidResponse((String)object)) {
                    block39: {
                        Object var25_28;
                        try {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                System.out.println(" the do CSP failed.. not a valid Response");
                                interruptedException.printStackTrace();
                                var25_28 = null;
                                break block39;
                            }
                            var25_28 = null;
                        }
                        catch (Throwable throwable) {
                            var25_28 = null;
                            throw throwable;
                        }
                    }
                    ++n2;
                    continue;
                }
                hashtable = parseResponse.getParsedData(string);
                break;
            }
            catch (HSCCIMException hSCCIMException) {
                throw hSCCIMException;
            }
            catch (InterruptedIOException interruptedIOException) {
                ++n3;
                System.out.println("Timed Out, the number of bytes send are :" + interruptedIOException.bytesTransferred);
                System.out.println(" the get Message is .." + interruptedIOException.getMessage());
                interruptedIOException.printStackTrace();
            }
            catch (IOException iOException) {
                System.err.println(" -- catched ioExcp : " + iOException);
                iOException.printStackTrace();
                ++n4;
                ++n2;
            }
        }
        if (hashtable != null) {
            return hashtable;
        }
        if (n4 > 0) {
            throw new HSCCIMException("0202");
        }
        if (n2 == 7) {
            object = "CSP Command Failed after " + n2 + " trys";
            System.out.println((String)object);
            throw new HSCCIMException("0201", new String[]{String.valueOf(n2)});
        }
        if (n3 != 3) throw new HSCCIMException("0204");
        object = "CSP Command Failed after " + n3 + " trys";
        System.out.println((String)object);
        throw new HSCCIMException("0201", new String[]{String.valueOf(n3)});
    }

    public static Hashtable doCSPCommand(String string, String[] stringArray, HscProviderSocket hscProviderSocket, long l, int n) throws CIMException {
        return HscProviderUtils.doCSPCommand(string, stringArray, hscProviderSocket, null, l, n);
    }

    public static Vector deletePartResAss(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle) throws CIMException {
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        Trace.trace("apcshscT", "ComputerSystemInstProv", "-> deletePartResAss");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Entry -> deletePartResAss");
        }
        try {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.associatorNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath, null, "GroupComponent", "PartComponent").elements();
            while (enumeration.hasMoreElements()) {
                try {
                    CIMObjectPath cIMObjectPath3;
                    CIMObjectPath cIMObjectPath4 = (CIMObjectPath)enumeration.nextElement();
                    CIMObjectPath cIMObjectPath5 = new CIMObjectPath(cIMObjectPath4.getObjectName(), cIMObjectPath4.getKeys());
                    cIMObjectPath5.setNameSpace("root/ibmhscV3_2");
                    vector.add(cIMObjectPath5);
                    CIMObjectPath cIMObjectPath6 = new CIMObjectPath("IBMHSC_AllocatedProcessor", "root/ibmhscV3_2");
                    Enumeration enumeration2 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath6, cIMObjectPath5, null).elements();
                    while (enumeration2.hasMoreElements()) {
                        cIMObjectPath3 = (CIMObjectPath)enumeration2.nextElement();
                        CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath3);
                    }
                    cIMObjectPath3 = new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2");
                    Enumeration enumeration3 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath5, null).elements();
                    while (enumeration3.hasMoreElements()) {
                        CIMObjectPath cIMObjectPath7 = (CIMObjectPath)enumeration3.nextElement();
                        CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath7);
                    }
                }
                catch (CIMException cIMException) {
                    cIMException.printStackTrace(System.err);
                    HSCLogUtils.serverLog(cIMException, HSCLogUtils._CECClassLogInfo);
                }
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace(System.err);
            Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deletePartResAss");
            throw cIMException;
        }
        Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deletePartResAss");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Exit -> deletePartResAss");
        }
        return vector;
    }

    public static void deleteHscInfo(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle) throws CIMException {
        Trace.trace("apcshscT", "HscProviderUtils", "-> deleteHscInfo");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Entry -> deleteHscInfo");
        }
        try {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysHscInfo", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.associatorNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath, null, "Antecedent", "Dependent").elements();
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                cIMOMHandle.deleteInstance(cIMObjectPath3);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace(System.err);
            Trace.trace("apcshscT", "HscProviderUtils", "<- deleteHscInfo");
            throw cIMException;
        }
        catch (Throwable throwable) {
            System.out.println(" failed in deleteHscInfo ..");
            throwable.printStackTrace();
        }
        Trace.trace("apcshscT", "HscProviderUtils", "<- deleteHscInfo");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Exit -> deleteHscInfo");
        }
    }

    public static void deleteServiceManages(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle) throws CIMException {
        Trace.trace("apcshscT", "HscProviderUtils", "-> deleteServicemanages");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Entry -> deleteServiceManages");
        }
        try {
            CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_ServiceManages", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath, null).elements();
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath3);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace(System.err);
            Trace.trace("apcshscT", "HscProviderUtils", "<- deleteserviceManages");
            throw cIMException;
        }
        Trace.trace("apcshscT", "HscProviderUtils", "<- deleteServiceManages");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Exit -> deleteServiceManages");
        }
    }

    public static void deleteMemoryResources(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle) throws CIMException {
        Trace.trace("apcshscT", "ComputerSystemInstProv", "-> deleteMemoryResources");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Entry -> deleteMemoryResources");
        }
        try {
            CIMObjectPath cIMObjectPath2;
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_CompSysMemory", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.associatorNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null, "GroupComponent", "PartComponent").elements();
            Enumeration enumeration2 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null).elements();
            while (enumeration2.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration2.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
            }
            while (enumeration.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace(System.err);
            Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deleteMemoryResources");
            throw cIMException;
        }
        Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deleteMemoryResources");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Exit -> deleteMemoryResources");
        }
    }

    public static void deleteProcessorResources(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle) throws CIMException {
        Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deleteProcessorResources");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Entry -> deleteProcessorResources");
        }
        try {
            CIMObjectPath cIMObjectPath2;
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_CompSysProcessor", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.associatorNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null, "GroupComponent", "PartComponent").elements();
            Enumeration enumeration2 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null).elements();
            while (enumeration2.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration2.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
            }
            while (enumeration.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace(System.err);
            Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deleteProcessorResources");
            throw cIMException;
        }
        Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deleteProcessorResources");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Exit -> deleteProcessorResources");
        }
    }

    public static void deleteIOResources(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle) throws CIMException {
        Trace.trace("apcshscT", "ComputerSystemInstProv", "-> deleteIOResources");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Entry -> deleteIOResources");
        }
        Vector<Object> vector = new Vector<Object>();
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath("IBMHSC_CompSysIODrawer", "root/ibmhscV3_2");
        try {
            Object object;
            Object object2;
            Enumeration enumeration = CimomWrapper.associatorNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath, null, "GroupComponent", "PartComponent").elements();
            while (enumeration.hasMoreElements()) {
                try {
                    object2 = (CIMObjectPath)enumeration.nextElement();
                    object = new CIMObjectPath(object2.getObjectName(), object2.getKeys());
                    object.setNameSpace("root/ibmhscV3_2");
                    vector.add(object);
                    HscProviderUtils.deleteSlotsOfDrawer((CIMObjectPath)object, cIMOMHandle, false);
                }
                catch (CIMException cIMException) {
                    cIMException.printStackTrace(System.err);
                    HSCLogUtils.serverLog(cIMException, HSCLogUtils._CECClassLogInfo);
                }
            }
            object2 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath, null).elements();
            while (object2.hasMoreElements()) {
                object = (CIMObjectPath)object2.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, (CIMObjectPath)object);
            }
            object = vector.elements();
            while (object.hasMoreElements()) {
                CIMObjectPath cIMObjectPath3 = (CIMObjectPath)object.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath3);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace(System.err);
            Trace.trace("apcshscT", "ComputerSystemInstProv", "-> deleteIOResources");
            throw cIMException;
        }
        Trace.trace("apcshscT", "ComputerSystemInstProv", "-> deleteIOResources");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Exit -> deleteIOResources");
        }
    }

    public static void deleteSlotsOfDrawer(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle, boolean bl) throws CIMException {
        Trace.trace("apcshscT", "HSCProviderUtils", "-> deleteSlotsOfDrawer");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Entry -> deleteSlotsOfDrawer");
        }
        try {
            CIMObjectPath cIMObjectPath2;
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_IODrawerSlot", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.associatorNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null, "GroupComponent", "PartComponent").elements();
            Enumeration enumeration2 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null).elements();
            while (enumeration2.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration2.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
            }
            while (enumeration.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                if (bl) {
                    cIMObjectPath3 = new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2");
                    Enumeration enumeration3 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath2, null).elements();
                    while (enumeration3.hasMoreElements()) {
                        CIMObjectPath cIMObjectPath4 = (CIMObjectPath)enumeration3.nextElement();
                        CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath4);
                    }
                }
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace(System.err);
            Trace.trace("apcshscT", "HSCProvUtils", "-> deleteSlotsOfDrawer");
            throw cIMException;
        }
        Trace.trace("apcshscT", "ComputerSystemInstProv", "-> deleteSlotsOfDrawer");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Exit -> deleteSlotsOfDrawer");
        }
    }

    public static void deletePartProfile(Vector vector, CIMOMHandle cIMOMHandle, boolean bl) throws CIMException {
        Trace.trace("apcshscT", "ComputerSystemInstProv", "-> deletePartProfile");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Entry -> deletePartProfile");
        }
        CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_PartitionProfile", "root/ibmhscV3_2");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                if (bl) {
                    CIMInstance cIMInstance = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath2, cIMOMHandle.getClass(cIMObjectPath2, false), false);
                    String string = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
                    if (string.equals("FullSystemPartition")) continue;
                    HscProviderUtils.deleteProfiles(cIMObjectPath, cIMObjectPath2, cIMOMHandle);
                    continue;
                }
                HscProviderUtils.deleteProfiles(cIMObjectPath, cIMObjectPath2, cIMOMHandle);
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace(System.err);
                HSCLogUtils.serverLog(cIMException, HSCLogUtils._CECClassLogInfo);
            }
        }
        Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deletePartProfile");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Exit -> deletePartProfile");
        }
    }

    public static void deleteProfiles(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, CIMOMHandle cIMOMHandle) throws CIMException {
        Trace.trace("apcshscT", "HscProviderUtils", "-> deleteProfiles");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Entry -> deleteProfiles");
        }
        try {
            CIMObjectPath cIMObjectPath3;
            CIMObjectPath cIMObjectPath4;
            CIMObjectPath cIMObjectPath5;
            Enumeration enumeration = CimomWrapper.associatorNames(cIMOMHandle, cIMObjectPath, cIMObjectPath2, null, "Element", "Setting").elements();
            Enumeration enumeration2 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath, cIMObjectPath2, null).elements();
            while (enumeration2.hasMoreElements()) {
                cIMObjectPath5 = (CIMObjectPath)enumeration2.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath5);
            }
            cIMObjectPath5 = new CIMObjectPath("IBMHSC_ActivatedLparProfile", "root/ibmhscV3_2");
            Enumeration enumeration3 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath5, cIMObjectPath2, null).elements();
            while (enumeration3.hasMoreElements()) {
                cIMObjectPath4 = (CIMObjectPath)enumeration3.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath4);
            }
            cIMObjectPath4 = new CIMObjectPath("IBMHSC_DefaultLparProfile", "root/ibmhscV3_2");
            Enumeration enumeration4 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath4, cIMObjectPath2, null).elements();
            while (enumeration4.hasMoreElements()) {
                cIMObjectPath3 = (CIMObjectPath)enumeration4.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath3);
            }
            while (enumeration.hasMoreElements()) {
                cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath3);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace(System.err);
            HSCLogUtils.serverLog(cIMException, HSCLogUtils._CECClassLogInfo);
        }
        Trace.trace("apcshscT", "HscProviderUtils", "<- deleteProfiles");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Exit -> deleteProfiles");
        }
    }

    public static void deletePartitions(CIMObjectPath cIMObjectPath, Vector vector, CIMOMHandle cIMOMHandle, boolean bl) throws CIMException {
        Trace.trace("apcshscT", "ComputerSystemInstProv", "-> deletePartitions");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Entry -> deletePartitions");
        }
        try {
            Object object;
            CIMInstance cIMInstance;
            Vector vector2;
            CIMObjectPath cIMObjectPath2;
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_CompSysPartition", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null).elements();
            while (enumeration.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                if (bl) {
                    vector2 = cIMObjectPath2.getKeys();
                    if (vector2 == null) continue;
                    cIMInstance = vector2.elements();
                    while (cIMInstance.hasMoreElements()) {
                        CIMObjectPath cIMObjectPath4;
                        Vector vector3;
                        object = (CIMProperty)cIMInstance.nextElement();
                        if (!"PartComponent".equalsIgnoreCase(object.getName()) || (vector3 = (cIMObjectPath4 = (CIMObjectPath)object.getValue().getValue()).getKeys()) == null) continue;
                        Enumeration enumeration2 = vector3.elements();
                        while (enumeration2.hasMoreElements()) {
                            String string;
                            String string2;
                            CIMProperty cIMProperty = (CIMProperty)enumeration2.nextElement();
                            if (!"Name".equalsIgnoreCase(cIMProperty.getName()) || (string2 = (string = (String)cIMProperty.getValue().getValue()).substring(0, 3)).equals("000")) continue;
                            CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
                        }
                    }
                    continue;
                }
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
            }
            cIMObjectPath2 = vector.elements();
            while (cIMObjectPath2.hasMoreElements()) {
                vector2 = (CIMObjectPath)cIMObjectPath2.nextElement();
                if (bl) {
                    cIMInstance = CimomWrapper.getInstance(cIMOMHandle, (CIMObjectPath)vector2, cIMOMHandle.getClass((CIMObjectPath)vector2, false), false);
                    object = (String)cIMInstance.getProperty("UserDefinedName").getValue().getValue();
                    if (((String)object).equals("FullSystemPartition")) continue;
                    CimomWrapper.deleteInstance(cIMOMHandle, (CIMObjectPath)vector2);
                    continue;
                }
                CimomWrapper.deleteInstance(cIMOMHandle, (CIMObjectPath)vector2);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace(System.err);
            Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deletePartitions");
            throw cIMException;
        }
        Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deletePartitions");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Exit -> deletePartitions");
        }
    }

    public static void deleteSysProfile(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle) throws CIMException {
        Trace.trace("apcshscT", "ComputerSystemInstProv", "-> deleteSysProfile");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Entry -> deleteSysProfile");
        }
        Vector<Object> vector = new Vector<Object>();
        try {
            CIMObjectPath cIMObjectPath2;
            Object object;
            Object object2;
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_CompSysProfile", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.associatorNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null, "Element", "Configuration").elements();
            while (enumeration.hasMoreElements()) {
                try {
                    object2 = (CIMObjectPath)enumeration.nextElement();
                    object = new CIMObjectPath(object2.getObjectName(), object2.getKeys());
                    object.setNameSpace("root/ibmhscV3_2");
                    vector.add(object);
                    cIMObjectPath2 = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2");
                    Enumeration enumeration2 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath2, (CIMObjectPath)object, null).elements();
                    while (enumeration2.hasMoreElements()) {
                        CIMObjectPath cIMObjectPath4 = (CIMObjectPath)enumeration2.nextElement();
                        CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath4);
                    }
                }
                catch (CIMException cIMException) {
                    cIMException.printStackTrace(System.err);
                    HSCLogUtils.serverLog(cIMException, HSCLogUtils._CECClassLogInfo);
                }
            }
            object2 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null).elements();
            while (object2.hasMoreElements()) {
                object = (CIMObjectPath)object2.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, (CIMObjectPath)object);
            }
            object = vector.elements();
            while (object.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)object.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace(System.err);
            Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deleteSysProfile");
            throw cIMException;
        }
        Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deleteSysProfile");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Exit -> deleteSysProfile");
        }
    }

    public static void deletePartionResources(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle) throws CIMException {
        Trace.trace("apcshscT", "ComputerSystemInstProv", "-> deletePartionResources");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Entry -> deletePartionResources");
        }
        try {
            CIMObjectPath cIMObjectPath2;
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_AllocatedProcessor", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null).elements();
            while (enumeration.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
            }
            cIMObjectPath2 = new CIMObjectPath("IBMHSC_AllocatedSlot", "root/ibmhscV3_2");
            Enumeration enumeration2 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath, null).elements();
            while (enumeration2.hasMoreElements()) {
                CIMObjectPath cIMObjectPath4 = (CIMObjectPath)enumeration2.nextElement();
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath4);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace(System.err);
            HSCLogUtils.serverLog(cIMException, HSCLogUtils._CECClassLogInfo);
        }
        Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deletePartionResources");
        if (GlobalConfig.debugLevel((int)1) > 0) {
            System.out.println("Exit -> deletePartionResources");
        }
    }

    public static String getHscID(CIMOMHandle cIMOMHandle) throws CIMException {
        block7: {
            CIMObjectPath cIMObjectPath = null;
            CIMClass cIMClass = null;
            Vector vector = null;
            CIMProperty cIMProperty = null;
            if (ComputerSystemProvUtils.HSC_MTMS == null) {
                try {
                    cIMObjectPath = new CIMObjectPath("IBMHSC_Console", "root/ibmhscV3_2");
                    cIMClass = cIMOMHandle.getClass(cIMObjectPath, false);
                    vector = CimomWrapper.enumInstances(cIMOMHandle, cIMObjectPath, false, cIMClass);
                    if (vector != null && vector.size() != 0) {
                        cIMObjectPath = (CIMObjectPath)vector.elementAt(0);
                        if (cIMObjectPath.getKeys() != null) {
                            Enumeration enumeration = cIMObjectPath.getKeys().elements();
                            while (enumeration.hasMoreElements()) {
                                cIMProperty = (CIMProperty)enumeration.nextElement();
                                if (!"Name".equalsIgnoreCase(cIMProperty.getName())) continue;
                                ComputerSystemProvUtils.HSC_MTMS = (String)cIMProperty.getValue().getValue();
                                break block7;
                            }
                            break block7;
                        }
                        throw new HSCCIMException("138C");
                    }
                    throw new HSCCIMException("138C");
                }
                catch (HSCCIMException hSCCIMException) {
                    throw hSCCIMException;
                }
                catch (Throwable throwable) {
                    throw new HSCCIMException("138C");
                }
            }
        }
        return ComputerSystemProvUtils.HSC_MTMS;
    }

    public static void handleCecInCompleteState(CIMOMHandle cIMOMHandle, CIMInstance cIMInstance, CIMInstance cIMInstance2, HscProviderSocket hscProviderSocket) {
        try {
            Hashtable hashtable;
            block4: {
                try {
                    hashtable = HscProviderUtils.doCSPCommand("GET_CEC_STATE", null, hscProviderSocket);
                }
                catch (Throwable throwable) {
                    System.out.println(" IN HANDLE CEC IN COMPLETE STATE");
                    System.out.println(" The Message is " + throwable.getMessage());
                    throwable.printStackTrace();
                    String string = HSCResourceBundleUtil.getMessage("HSCCIMExceptionBundle", "0200");
                    System.out.println(" the error mesg is ,," + string);
                    if (!throwable.getMessage().equalsIgnoreCase(string)) break block4;
                    cIMInstance.setProperty("state", new CIMValue((Object)new UnsignedInt8(254)));
                }
            }
            hashtable = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            hashtable.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.setInstance(cIMOMHandle, (CIMObjectPath)hashtable, cIMInstance);
        }
        catch (CIMException cIMException) {
            System.out.println(" failed to update cimom in handleCecInCompleteState.");
            cIMException.printStackTrace();
        }
        AsynchEventManager.sendIndication(4, cIMInstance, cIMInstance2);
    }

    public static boolean checkPermission(Permission permission, CodeSource codeSource) {
        AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = Subject.getSubject(accessControlContext);
        Policy policy = Policy.getPolicy();
        if (!HSC_ACCESS_CONTROL) {
            return true;
        }
        PermissionCollection permissionCollection = codeSource != null ? policy.getPermissions(subject, codeSource) : policy.getPermissions(subject, new CodeSource(null, null));
        if (permission == null || permissionCollection == null) {
            return false;
        }
        return permissionCollection.implies(permission);
    }

    public static CIMObjectPath slot2cop(int n, String string) {
        CIMObjectPath cIMObjectPath = null;
        String string2 = String.valueOf(n);
        int n2 = string2.length();
        while (n2 < 3) {
            string2 = "0" + string2;
            ++n2;
        }
        string2 = string2 + "*" + string;
        cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", "root/ibmhscV3_2");
        cIMObjectPath.addKey("Name", new CIMValue((Object)string2));
        cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
        return cIMObjectPath;
    }

    public static void deleteReferences(CIMOMHandle cIMOMHandle, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        CIMObjectPath cIMObjectPath2 = new CIMObjectPath(string, "root/ibmhscV3_2");
        Enumeration enumeration = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath2, cIMObjectPath, null).elements();
        while (enumeration.hasMoreElements()) {
            CIMObjectPath cIMObjectPath3 = (CIMObjectPath)enumeration.nextElement();
            try {
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath3);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._LPARClassLogInfo);
                throwable.printStackTrace();
                if (GlobalConfig.debugLevel((int)1) <= 0) continue;
                throwable.printStackTrace();
            }
        }
    }

    public static void deleteCimLparProf(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, HscProviderSocket hscProviderSocket) throws CIMException {
        short s;
        String string;
        CIMInstance cIMInstance;
        block15: {
            block14: {
                block13: {
                    block12: {
                        cIMInstance = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath, new CIMClass("IBMHSC_LparProfile"), false);
                        String string2 = (String)cIMInstance.getProperty("PartitionName").getValue().getValue();
                        string = (String)cIMInstance.getProperty("SettingID").getValue().getValue();
                        s = Short.parseShort(string2.substring(0, 3));
                        try {
                            HscProviderUtils.deleteReferences(cIMOMHandle, "IBMHSC_InSysProfile", cIMObjectPath);
                        }
                        catch (Throwable throwable) {
                            HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
                            throwable.printStackTrace();
                            if (GlobalConfig.debugLevel((int)1) <= 0) break block12;
                            throwable.printStackTrace();
                        }
                    }
                    try {
                        HscProviderUtils.deleteReferences(cIMOMHandle, "IBMHSC_ActivatedLparProfile", cIMObjectPath);
                    }
                    catch (Throwable throwable) {
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
                        if (GlobalConfig.debugLevel((int)1) <= 0) break block13;
                        throwable.printStackTrace();
                    }
                }
                try {
                    HscProviderUtils.deleteReferences(cIMOMHandle, "IBMHSC_DefaultLparProfile", cIMObjectPath);
                }
                catch (Throwable throwable) {
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
                    if (GlobalConfig.debugLevel((int)1) <= 0) break block14;
                    throwable.printStackTrace();
                }
            }
            try {
                HscProviderUtils.deleteReferences(cIMOMHandle, "IBMHSC_PartitionProfile", cIMObjectPath);
            }
            catch (Throwable throwable) {
                HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
                if (GlobalConfig.debugLevel((int)1) <= 0) break block15;
                throwable.printStackTrace();
            }
        }
        CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath);
        try {
            AsynchEventManager.sendIndication(2, cIMInstance, null);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._RestoreClassLogInfo);
        }
        try {
            HscProviderUtils.doCSPCommand("SET_NOTIFICATION_EVENT_CEC_LPAR_PROFILE_DELETE", new String[]{"0", HscProviderUtils.getHscID(cIMOMHandle), "4", "2", Integer.toHexString(s), string}, hscProviderSocket);
        }
        catch (Throwable throwable) {
            HSCLogUtils.serverLog(throwable, HSCLogUtils._ProfileClassLogInfo);
        }
    }

    public static CIMObjectPath getInSysProfCop(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2, CIMOMHandle cIMOMHandle) {
        CIMObjectPath cIMObjectPath3 = null;
        CIMObjectPath cIMObjectPath4 = null;
        try {
            cIMObjectPath3 = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2");
            cIMObjectPath3.addKey("Context", new CIMValue((Object)cIMObjectPath));
            CIMInstance cIMInstance = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_LparProfile"), false);
            String string = (String)cIMInstance.getProperty("PartitionName").getValue().getValue();
            String string2 = (String)cIMInstance.getProperty("SettingID").getValue().getValue();
            cIMObjectPath4 = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
            cIMObjectPath4.addKey("SettingID", new CIMValue((Object)string2));
            cIMObjectPath4.addKey("PartitionName", new CIMValue((Object)string));
            cIMObjectPath4.addKey("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMObjectPath3.addKey("Setting", new CIMValue((Object)cIMObjectPath4));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return cIMObjectPath3;
    }

    public static float getCSPVersion(HscProviderSocket hscProviderSocket) throws HSCCIMException {
        float f = -1.0f;
        try {
            Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_CSP_INTERFACE_VERSION_NUMBER", null, hscProviderSocket);
            String string = (String)hashtable.get("VERSION");
            string = string.trim();
            String string2 = string.substring(1);
            f = new Float(string2).floatValue();
        }
        catch (Throwable throwable) {
            throw new HSCCIMException(throwable);
        }
        return f;
    }

    public static Hashtable getCapabilities(String string, HscProviderSocket hscProviderSocket) throws HSCCIMException {
        Hashtable<String, Integer> hashtable;
        block6: {
            System.out.println("In getCapabilities!");
            hashtable = new Hashtable<String, Integer>();
            Hashtable hashtable2 = new Hashtable();
            int n = 0;
            try {
                hashtable2 = HscProviderUtils.doCSPCommand("GET_CEC_CAPABILITY_MODE", null, hscProviderSocket, string);
                short s = ((Integer)hashtable2.get("CAPABILITY")).shortValue();
                System.out.println("tmpCecCap: " + s);
                int n2 = (Integer)hashtable2.get("MODE");
                int n3 = s & 7;
                System.out.println("modified CEC capability: " + n3);
                Integer n4 = new Integer(n3);
                hashtable.put("CecCapability", new Integer(s));
                hashtable.put("CecMode", new Integer(n2));
                int n5 = VersionComparator.CSPVersionValue(string);
                if ((float)n5 <= 2000.0f) {
                    n = s & 0x38;
                    System.out.println("runtimeCap: " + n);
                    Integer n6 = new Integer(n);
                    hashtable.put("RuntimeCapability", n6);
                }
                if (!((float)n5 >= 3000.0f)) break block6;
                hashtable2 = HscProviderUtils.doCSPCommand("GET_CEC_STATE", null, hscProviderSocket, string);
                short s2 = ((Integer)hashtable2.get("CEC_STATE")).shortValue();
                hashtable.put("CEC_STATE", (Integer)hashtable2.get("CEC_STATE"));
                if (s2 != 3) {
                    try {
                        hashtable2 = HscProviderUtils.doCSPCommand("GET_CEC_RUNTIME_CAPABILITIES", null, hscProviderSocket, string);
                        n = (Integer)hashtable2.get("CAPABILITY");
                        System.out.println("Runtime capability: " + n);
                    }
                    catch (Throwable throwable) {
                        n = 0;
                        HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                    }
                }
                Integer n7 = new Integer(n);
                hashtable.put("RuntimeCapability", n7);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                throw new HSCCIMException(throwable);
            }
        }
        System.out.println("hash: " + hashtable);
        return hashtable;
    }

    public static String getCecNameFromCecObjPath(CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
        String string = (String)cIMInstance.getProperty("Name").getValue().getValue();
        return string;
    }

    public static String getCecNameFromProfileObjPath(CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
        String string = (String)cIMInstance.getProperty("PartitionName").getValue().getValue();
        String string2 = string.substring(string.indexOf(42) + 1);
        return string2;
    }

    public static String getCecNameFromSysProfileObjPath(CIMObjectPath cIMObjectPath, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        CIMInstance cIMInstance = CimomWrapper.getInstance((CIMOMHandle)providerCIMOMHandle, cIMObjectPath, providerCIMOMHandle.getClass(cIMObjectPath, false), false);
        String string = (String)cIMInstance.getProperty("ComputerSystemName").getValue().getValue();
        return string;
    }

    public static void deleteFrameAss(CIMObjectPath cIMObjectPath, CIMOMHandle cIMOMHandle) throws CIMException {
        Trace.trace("apcshscT", "HscProviderUtils", "-> deleteFrameAss");
        try {
            CIMObjectPath cIMObjectPath2;
            CIMObjectPath cIMObjectPath3 = new CIMObjectPath("IBMHSC_FrameCompSys", "root/ibmhscV3_2");
            Enumeration enumeration = CimomWrapper.associatorNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null, "PartComponent", "GroupComponent").elements();
            System.out.println("The enumeration of frame inst :" + enumeration);
            Enumeration enumeration2 = CimomWrapper.referenceNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath, null).elements();
            while (enumeration2.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration2.nextElement();
                System.out.println("The Frame Association Object Path is :" + cIMObjectPath2);
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
            }
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath4;
                cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                System.out.println("The Frame Object Path is :" + cIMObjectPath2);
                CIMInstance cIMInstance = CimomWrapper.getInstance(cIMOMHandle, cIMObjectPath2, new CIMClass("IBMHSC_Frame"), false);
                boolean bl = (Boolean)cIMInstance.getProperty("isFrame").getValue().getValue();
                if (bl) continue;
                System.out.println("frame op: " + cIMObjectPath2);
                System.out.println("cop: " + cIMObjectPath3);
                Vector vector = CimomWrapper.associatorNames(cIMOMHandle, cIMObjectPath3, cIMObjectPath2, null, null, null);
                if (vector != null && vector.size() > 1) continue;
                if (vector.size() == 1 && !(cIMObjectPath4 = (CIMObjectPath)vector.elementAt(0)).equals((Object)cIMObjectPath)) {
                    System.out.println("op: " + cIMObjectPath);
                    System.out.println("cecOp: " + cIMObjectPath4);
                    continue;
                }
                CimomWrapper.deleteInstance(cIMOMHandle, cIMObjectPath2);
                AsynchEventManager.sendIndication(2, cIMInstance, null);
            }
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace(System.err);
            Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deleteMemoryResources");
            throw cIMException;
        }
        Trace.trace("apcshscT", "ComputerSystemInstProv", "<- deleteMemoryResources");
    }

    static {
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(CONFIG_PROP_FILENAME);
            mProps = new Properties();
            mProps.load(fileInputStream);
            String string2 = (String)mProps.get(APP_TIMEOUT_PROP_NAME);
            if (string2 != null) {
                mSocketTimeoutValue = Integer.parseInt(string2);
                mSocketTimeoutValue *= 1000;
            }
            if ((string = (String)mProps.get(CMD_BUSY_TIMEOUT)) != null) {
                mCmdBusyTimeoutValue = Integer.parseInt(string);
                System.out.println("CMD_BUSY_TIMEOUT=" + (mCmdBusyTimeoutValue *= 1000));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

